const express = require('express'); //requires express module
const mongoose = require("mongoose");
const socket = require('socket.io'); //requires socket.io module
// Assuming you have a connection to the notification server
const notificationSocket = require('socket.io-client')('http://starapi.stararabgroup.com:3008');

const fs = require('fs');
var mysql = require('mysql');
const app = express();
var PORT = process.env.PORT || 1883;
const server = app.listen(PORT); //tells to host server on localhost:3000


//Playing variables:
app.use(express.static('public')); //show static files in 'public' directory

const User = require("./model/user.model");
const Payment = require("./model/payment.model");

const GreedyTable = require("./model/greedy_table.model");
const GreedyBid = require("./model/greedy_bid.model");
const AppSetting = require("./model/appSetting.model");
const GameTransaction = require("./model/gameTransaction.model");

console.log('Server is running');
const io = socket(server, {
  cors: {
    origin: "*",
  }
});

mongoose.connect(
    `mongodb+srv://mohammad:FlvC33mQ3LZoBNHx@cluster0.jxnn5.mongodb.net/stararabchat_prod`,

    {
        useNewUrlParser: true,
        useUnifiedTopology: true,
    }
);

const db = mongoose.connection;

db.on("error", console.error.bind(console, "connection error:"));
db.once("open", () => {
    console.log("MONGO: successfully connected to db");
});


let result = 0;
let seat_1 = 0;
let seat_2 = 0;
let seat_3 = 0;
let seat_4 = 0;
let seat_5 = 0;
let seat_6 = 0;
let seat_7 = 0;
let seat_8 = 0;
let actual_seat_1 = 0;
let actual_seat_2 = 0;
let actual_seat_3 = 0;
let actual_seat_4 = 0;
let actual_seat_5 = 0;
let actual_seat_6 = 0;
let actual_seat_7 = 0;
let actual_seat_8 = 0;

let customRes = false;
let count = Math.floor(Date.now()/1000)-((Math.floor(Math.floor(Date.now()/1000)/30))*30);
let status = count < 20 ? 1 : (count < 25 ? 2 : 3);
let counter = count < 20 ? 20-count : (count < 25 ?  5-(count-20) : 5-(count-25));
let sessionId = (Math.floor(Math.floor(Date.now()/1000)/30));

const resultarrs = [1,8,4,8,1,4,7,5,6,8,6,1,4,6,7,4,3,7,5,6,4,3,7,3,4,6,1,3,7,2,7,2,7,1,7,2,7,4,7,3,5,3,5,7,6,4,3,6,7,6,7,3,7,2,3,2,5,1,5,3,1,2,5,1,3,7,2,7,1,3,5,3,4,1,3,4,2,3,2,3,5,3,1,7,2,5,2,1,2,1,5,1,5,1,5,1,5,1,5,1,6,5,7,3,1,6,2,3,1,5,7,5,4,6,1,4,1,3,7,8,2,7,6,1,5,3,4,2,1,7,2,7,2,8,1,4,2,3,2,6,2,4,1,7,1,3,2,6,3,1,7,1,6,8,7,1,5,6,7,4,1,5,4,5,1,3,6,2,5,3,7,2,5,2,3,1,7,5,4,7,4,5,7,5,3,1,5,4,5,3,1,7,3,7,3,7,3,5,3,5,7,5,7,3,4,3,4,7,1,7,1,7,8,2,4,5,3,6,1,7,8,6,1,5,2,5,7,6,2,3,8,7,5,6,7,1,7,5,3,4,5,2,4,1,7,1,4,5,2,5,3,6,1,6,3,2,5,3,7,6,7,3,6,2,3,4,5,3,1,4,3,5,1,7,3,4,2,4,2,5,3,2,7,2,1,2,3,5,1,3,5,7,1,7,1,5,3,1,5,7,4,3,1,2,4,3,7,2,5,7,1,8,4,1,7,6,5,4,7,8,2,4,5,6,4,6,5,3,8,3,7,2,1,6,7,2,4,6,5,1,4,2,4,6,1,5,6,5,7,4,3,6,2,5,4,1,7,3,5,3,2,3,1,7,2,5,3,2,7,2,7,5,7,3,7,1,3,7,5,7,2,3,1,3,1,5,7,1,3,5,7,1,3,5,1,5,1,3,5,1,3,4,2,1,2,1,6,4,2,4,3,1,3,7,1,6,7,6,1,7,1,8,7,2,5,4,6,3,8,3,8,2,1,5,7,2,1,2,3,1,3,2,1,7,5,7,3,1,5,6,7,6,7,5,6,7,6,2,5,3,1,7,5,7,1,5,3,2,4,7,5,3,2,5,7,4,5,3,2,4,5,4,1,7,3,7,5,3,7,4,3,5,1,4,3,1,3,1,3,5,5,4,6,2,8,2,1,7,4,3,6,7,8,1,3,8,2,7,2,1,3,6,5,2,4,5,1,2,6,4,6,1,6,2,6,1,4,5,6,3,4,1,5,7,5,2,5,1,5,4,5,2,1,2,3,5,2,3,7,2,1,4,5,4,1,5,7,5,1,5,1,5,3,7,3,7,5,3,4,7,5,3,7,1,7,3,7,1,3,5,3,1,7,3,7,3,1,3,7,3,1,8,6,8,4,1,6,8,7,6,3,2,7,6,2,6,7,6,2,4,5,7,4,3,6,7,5,1,6,5,7,5,7,3,1,4,5,1,4,3,7,5,7,1,5,1,2,7,3,4,5,7,3,5,1,7,4,7,3,4,3,7,5,2,7,4,2,5,3,4,5,3,2,7,5,2,7,5,3,1,3,5,1,3,2,5,1,3,1,2,1,5,1,2,1,2,1,3,1,3,3,7,8,2,1,3,5,7,5,7,2,4,7,6,8,4,7,3,5,3,1,3,8,2,5,3,1,7,5,3,1,7,1,3,6,3,4,5,7,1,3,6,2,4,7,5,1,7,6,5,4,6,2,1,7,4,7,3,5,1,2,6,2,5,2,1,5,6,4,3,2,4,6,7,3,2,5,2,1,2,7,5,4,7,1,7,5,7,5,3,5,4,1,3,1,5,1,3,1,3,8,6,8,1,3,6,4,6,7,3,4,7,1,6,1,4,7,1,6,8,7,4,3,1,5,1,3,2,1,8,5,6,1,6,1,3,5,3,5,1,7,4,5,7,3,4,6,7,4,2,5,1,4,5,3,7,3,4,7,1,7,3,1,4,2,3,1,7,3,2,5,7,5,7,2,1,3,2,7,1,3,5,3,1,3,7,3,7,5,2,5,7,5,2,5,2,5,2,5,2,4,5,7,1,5,8,4,1,8,1,5,1,5,2,6,7,5,6,3,2,5,6,4,5,2,3,7,6,2,4,7,2,5,8,5,4,6,3,7,4,1,7,5,3,2,4,7,4,6,7,4,6,5,1,4,5,3,4,5,7,5,7,3,6,1,2,7,3,7,1,2,1,2,3,1,7,1,7,3,7,2,5,7,5,1,5,3,1,3,2,3,1,7,2,3,1,3,1,3,1,1,3,5,1,8,6,3,1,4,2,3,7,4,6,2,1,7,4,6,7,1,6,5,1,4,5,2,6,1,5,4,2,1,2,1,3,4,6,3,7,4,3,4,8,5,1,3,2,6,3,4,6,4,2,5,2,7,2,5,3,7,4,3,1,7,1,5,2,5,1,2,7,1,5,7,5,3,4,5,7,3,1,5,7,3,2,7,5,3,5,7,1,7,3,7,3,1,2,5,7,5,6,3,2,1,4,1,6,5,3,4,4,3,7,6,2,1,5,3,5,2,7,2,1,2,6,2,6,1,3,7,4,1,2,1,6,7,1,2,7,2,7,8,4,7,5,4,5,7,2,1,7,4,6,2,3,1,3,5,1,5,3,4,5,1,2,7,5,4,5,1,2,7,2,4,1,4,7,4,6,5,3,1,8,7,1,5,7,5,3,7,3,5,3,7,3,5,3,5,3,3,5,2,4,7,4,3,5,6,4,1,4,2,3,8,7,4,3,2,6,1,3,7,3,1,6,3,5,2,3,1,6,1,3,7,6,5,7,1,2,5,6,5,1,6,4,7,3,2,7,6,4,7,2,5,8,3,5,3,7,1,4,5,2,5,3,4,2,7,1,7,4,1,4,3,4,3,5,2,5,2,1,2,1,5,3,5,3,2,5,2,5,1,7,1,7,1,7,1,7,3,4,2,8,1,6,1,5,6,3,1,2,6,4,5,1,6,5,3,1,5,6,1,5,3,7,4,5,7,1,4,3,4,5,7,3,1,2,1,4,1,2,1,4,5,2,5,8,3,5,2,3,4,7,2,3,2,1,6,5,7,2,3,6,2,1,2,5,7,4,7,1,7,1,5,7,5,4,7,2,6,1,3,7,5,7,3,7,3,5,7,4,7,4,2,3,2,3,7,3,5,6,4,7,2,6,3,2,4,7,6,4,6,4,6,5,1,7,8,2,1,2,4,5,6,1,7,1,2,7,1,6,5,7,2,3,5,4,3,7,6,4,5,1,4,1,3,2,1,2,3,4,7,1,4,2,4,7,8,3,1,2,5,2,3,4,1,2,1,3,7,5,7,5,2,5,1,5,1,2,1,7,5,3,1,7,3,7,5,7,3,5,7,3,5,3,5,3,5,3,3,7,8,2,1,4,5,1,4,1,2,4,2,4,2,3,2,3,7,1,3,2,7,4,6,5,6,2,3,1,6,4,1,6,3,7,6,5,3,6,4,2,7,6,4,3,4,2,3,2,1,2,3,5,6,2,3,5,7,2,1,7,5,2,7,5,3,1,4,5,4,1,7,3,8,7,4,7,3,1,3,5,1,5,7,5,7,1,5,3,1,5,7,3,5,7,1,5,1,5,7,6,1,3,1,4,6,5,4,2,8,6,2,4,3,5,7,5,7,3,4,1,2,6,3,5,4,6,4,1,4,3,6,4,8,2,4,5,6,5,7,1,2,3,2,6,3,1,5,7,4,2,5,2,1,7,5,7,2,7,3,1,2,7,2,1,4,5,7,2,5,3,1,3,7,2,1,2,1,4,3,1,5,7,3,5,3,5,7,3,1,7,3,1,5,7,5,3,7,1,7,3,7,3,1,3,5,7,4,3,7,2,7,3,6,3,5,3,1,2,5,2,1,6,2,6,5,8,6,2,3,7,3,6,2,4,3,2,3,7,6,4,3,5,7,2,1,8,7,1,2,5,6,2,3,4,1,5,1,2,6,2,7,4,3,5,1,5,1,4,3,4,2,5,2,3,7,5,4,7,5,4,7,5,4,1,4,1,7,4,7,5,7,1,5,1,7,1,5,1,5,7,4,8,2,4,6,7,1,7,4,6,1,5,3,5,1,7,5,1,2,3,1,3,6,7,2,5,1,5,4,6,4,7,1,2,1,2,1,7,4,1,2,4,1,7,4,6,1,6,1,2,7,5,4,3,6,3,6,2,4,2,1,4,3,5,2,5,8,3,2,7,2,3,2,4,3,1,2,1,7,3,7,5,7,3,5,7,5,7,3,7,3,5,3,5,3,5,3,5,8,3,5,7,6,1,5,1,3,1,3,7,2,4,3,5,7,2,5,2,4,6,3,5,3,2,3,1,4,8,1,6,2,6,1,7,1,6,4,7,7,5,6,5,1,6,7,5,6,2,4,1,2,3,1,5,1,2,7,3,7,1,5,3,4,7,3,2,3,1,8,4,3,1,7,2,5,2,7,2,3,7,3,4,3,5,7,4,2,7,2,4,1,5,4,1,5,4,7,5,6,1,6,8,2,5,1,7,4,7,1,5,1,6,7,3,1,6,1,5,2,1,6,5,6,1,2,3,1,5,7,5,7,3,5,2,1,5,7,5,4,6,4,6,2,6,2,4,7,5,3,2,7,4,3,1,3,1,7,4,5,4,8,2,4,5,2,1,2,3,1,2,1,5,1,7,4,3,4,7,4,2,3,4,3,7,3,2,5,7,2,7,3,5,3,5,7,3,7,3,1,7,4,6,1,7,5,3,4,2,7,2,3,7,3,6,2,5,7,6,3,7,4,1,2,5,7,1,3,1,7,5,7,2,1,5,6,4,6,7,6,7,8,1,4,3,5,1,4,5,4,7,2,6,7,2,5,3,5,1,7,5,7,5,3,2,1,6,4,7,3,5,8,3,4,1,5,3,4,5,2,3,5,4,1,2,1,4,2,3,2,3,5,2,3,1,3,1,2,1,1,2,1,2,6,3,6,8,6,2,5,4,6,7,7,4,1,7,6,4,7,1,2,5,4,7,6,1,2,4,3,4,3,5,3,1,5,7,1,4,6,5,4,2,7,3,4,1,7,2,1,4,2,3,1,3,8,5,6,7,4,1,3,7,4,3,1,5,1,2,5,7,5,7,3,1,7,1,5,1,5,3,5,7,3,5,7,5,3,2,3,1,3,5,3,2,5,2,7,2,2,5,7,3,2,3,4,6,1,3,2,6,4,6,2,8,2,4,7,5,2,1,2,4,1,4,5,2,6,8,7,3,5,6,3,2,6,4,3,4,6,4,6,4,2,7,4,2,4,2,7,4,1,5,2,3,2,1,5,1,2,7,1,5,7,1,7,1,3,5,3,7,5,7,5,1,5,7,3,1,3,1,5,7,3,5,1,3,1,5,1,5,1,7,5,7,3,7,3,7,1,2,7,5,6,5,3,5,3,2,7,6,5,8,6,7,6,3,5,7,4,1,3,4,1,4,7,2,3,2,3,2,6,5,4,1,5,1,6,1,6,4,7,6,2,7,3,1,2,1,3,2,8,4,5,3,2,1,3,5,4,1,7,4,3,1,7,1,3,4,5,1,5,2,7,4,3,1,2,1,4,7,1,4,7,5,2,7,1,3,5,2,7,2,5,7,3,7,3,5,1,8,3,6,3,2,7,4,7,3,4,2,1,5,3,5,3,5,6,1,3,6,1,6,3,5,7,6,7,1,6,4,3,5,1,6,1,3,1,4,6,7,3,7,3,2,1,3,1,4,2,7,1,2,5,3,7,5,8,3,2,5,2,1,7,2,4,2,1,4,5,3,2,1,2,7,2,7,5,4,7,2,1,4,5,2,3,7,5,4,1,5,7,1,7,4,5,4,7,5,8,1,6,7,4,7,6,3,1,7,6,4,3,5,4,6,1,7,7,5,7,6,4,3,4,5,4,5,4,1,6,5,3,2,1,4,8,1,2,5,7,2,7,3,5,3,4,1,2,6,7,4,7,4,1,7,3,6,7,3,7,1,4,1,8,5,1,2,7,3,2,1,3,7,2,5,2,7,5,1,5,1,3,5,2,5,3,1,3,5,2,5,2,1,2,5,2,3,2,3,3,5,7,8,7,3,7,5,6,6,4,2,4,6,7,4,5,3,2,5,2,6,5,3,1,2,7,6,7,4,3,4,6,4,6,4,2,7,3,5,6,2,3,2,5,2,5,4,7,1,2,8,3,7,4,2,4,3,4,1,2,3,7,5,7,1,5,7,4,3,7,2,5,3,7,1,7,1,7,1,3,1,5,1,5,2,1,3,1,2,3,1,3,1,3,5,1,5,1,5,4,1,4,1,5,4,6,7,5,4,2,7,2,4,2,5,8,1,4,2,6,1,2,7,3,2,1,7,6,4,5,3,2,2,5,4,2,6,1,5,6,7,3,4,2,5,6,7,5,2,6,3,2,6,5,2,3,4,3,8,2,4,5,4,7,4,7,5,1,5,1,3,5,7,5,7,3,7,3,1,7,3,7,1,7,5,1,7,3,5,1,7,3,1,3,1,3,1,3,1,8,5,2,1,2,6,2,4,3,1,5,2,4,6,4,2,5,4,5,3,6,4,2,6,7,1,7,8,2,4,6,5,6,7,3,6,1,4,1,5,6,5,1,2,7,1,7,5,1,5,1,4,2,1,4,5,3,7,1,3,2,5,1,3,2,1,5,1,3,5,3,8,5,7,5,3,2,7,2,5,4,1,2,1,7,4,7,4,3,7,3,7,3,7,3,7,3,7,3,7,1,6,8,7,4,6,6,4,7,4,6,3,2,6,3,6,7,4,6,5,1,4,5,4,7,6,2,7,1,5,3,4,3,5,3,4,2,1,7,1,2,3,5,1,7,4,5,3,8,5,2,3,2,1,5,2,4,3,2,1,3,7,1,5,7,3,5,2,1,7,1,4,3,7,5,4,1,7,3,1,7,2,7,1,2,5,7,2,5,3,1,3,5,2,5,3,2,5,1,7,2,1,5,2,1,2,4,6,7,4,6,8,4,3,4,3,6,3,1,7,3,1,2,1,3,4,2,3,6,1,2,3,5,4,6,2,5,1,5,2,1,6,7,3,5,1,6,2,7,4,2,7,2,4,5,4,1,2,5,7,6,7,2,3,1,4,7,1,8,4,5,2,5,1,2,5,1,5,3,5,7,4,5,1,5,1,7,5,3,7,5,7,3,7,3,7,3,7,3,7,8,7,2,3,1,5,3,6,2,1,5,3,1,4,5,6,5,2,4,6,4,6,1,3,4,1,2,4,5,2,1,7,1,8,7,1,5,4,6,1,5,4,3,5,4,2,1,6,3,5,7,4,1,7,1,6,1,7,5,1,6,1,5,8,4,5,3,7,2,3,5,4,1,4,7,3,2,3,2,7,2,3,7,2,7,5,2,5,2,5,7,3,7,3,7,3,2,3,7,3,7,5,8,4,3,5,5,1,5,6,7,2,5,2,5,6,1,2,7,6,7,6,3,7,6,4,6,1,3,2,7,4,6,1,4,1,5,8,4,3,4,7,4,1,4,1,7,6,5,1,2,7,4,1,3,2,4,1,4,1,4,5,1,7,2,1,5,7,1,3,5,1,3,5,2,1,2,3,5,3,5,3,2,3,2,5,3,5,7,3,2,3,7,2,7,3,2,7,3,7,3,4,1,8,7,3,3,1,3,4,5,4,6,1,7,2,1,2,3,2,4,5,4,6,4,2,5,7,3,4,3,5,2,6,1,6,7,2,3,6,4,5,1,4,1,7,3,4,5,6,4,2,4,6,7,3,6,1,5,2,7,3,5,1,2,3,5,7,5,8,2,5,2,5,7,2,3,5,7,1,5,7,3,7,5,3,5,1,7,3,2,1,3,1,7,1,7,1,2,7,7,2,6,7,1,2,1,3,5,6,2,8,3,4,6,3,6,5,2,7,5,4,5,1,4,3,5,2,1,2,1,4,7,3,5,6,3,4,7,5,6,3,4,2,3,7,2,3,1,2,7,3,1,3,4,2,1,7,4,8,5,1,2,5,3,6,4,5,7,4,6,2,7,2,7,3,7,5,1,3,7,5,4,5,1,4,5,3,5,2,7,1,3,1,7,1,7,5,7,1,3,7,2,1,3,2,7,1,2,3,1,7,5,4,3,2,3,8,6,1,6,3,4,1,2,7,2,4,7,1,3,2,7,2,7,2,3,7,2,7,2,3,4,1,6,4,3,5,4,7,3,5,3,1,2,6,5,7,5,2,5,2,3,5,4,5,3,7,8,6,4,6,4,1,7,3,4,3,5,6,4,3,7,4,5,1,5,1,7,5,7,1,5,6,1,5,1,5,1,5,3,7,3,2,5,2,3,7,5,7,4,6,2,7,3,5,7,6,5,3,1,6,1,8,3,2,1,2,4,6,5,4,1,4,2,5,7,5,6,4,2,6,3,5,7,1,3,6,1,6,5,3,7,5,2,3,1,5,3,4,3,5,1,5,7,3,7,5,7,1,3,2,5,2,4,2,1,5,2,3,7,2,4,8,7,3,2,4,7,4,1,3,1,4,1,4,7,1,7,1];
//Socket.io Connection------------------
io.on('connection', async (socket) => {

    console.log("New socket connection: " + socket.id)
    socket.on('join', function (data) {    
        socket.join(data);
        const uid = data;
        console.log("join: "+uid);
        if (uid == 1614626426 ) {
            console.log("banned join: "+uid);
            socket.disconnect(true);
        }
    });
    let history = [];
    const greedyHistory = await GreedyTable.aggregate([
        {
            $match: {
                session: { $lt: sessionId } // Replace with actual sessionId ObjectId
            }
        },
        {
            $sort: { session: -1 } // Sort by session in descending order
        },
        {
            $limit: 15 // Limit results to 15 documents
        },
        {
            $project: {
                result: 1, // Include only the "result" field
                session: 1 // Convert session ObjectId to string
            }
        }
    ]);

    for (const value of greedyHistory) {
        const index = greedyHistory.indexOf(value);
        history.push(value.result);
    }
    io.emit('history', {"history": history});
    
    socket.on('setResult', data => {
        if (status < 2) {
            result = data;
            customRes = true
            io.emit("setResultRes", result);
        }
    });
    
    let myBiddingSeat_1 = 0;
    let myBiddingSeat_2 = 0;
    let myBiddingSeat_3 = 0;
    let myBiddingSeat_4 = 0;
    let myBiddingSeat_5 = 0;
    let myBiddingSeat_6 = 0;
    let myBiddingSeat_7 = 0;
    let myBiddingSeat_8 = 0;
    
    let userUid = 0;
    let userId = 0;
    let userName = "";
    let userImage = "";
    
    let oldOwnStatus = 0;
    let notBet = true;
    var t=setInterval(async function () {
        sessionId = (Math.floor(Math.floor(Date.now()/1000)/30));
        count = Math.floor(Date.now()/1000)-((Math.floor(Math.floor(Date.now()/1000)/30))*30);
        const Ownstatus = count < 20 ? 1 : (count < 25 ? 2 : 3);
        if (oldOwnStatus != Ownstatus) {
            io.emit('roundChange', sessionId);
        }
        if (oldOwnStatus != Ownstatus && Ownstatus == 1) {
            notBet = true;
            myBiddingSeat_1 = 0;
            myBiddingSeat_2 = 0;
            myBiddingSeat_3 = 0;
            myBiddingSeat_4 = 0;
            myBiddingSeat_5 = 0;
            myBiddingSeat_6 = 0;
            myBiddingSeat_7 = 0;
            myBiddingSeat_8 = 0;
            io.emit('bidding', {"bidder": userUid,"seat_1": myBiddingSeat_1,"seat_2": myBiddingSeat_2,"seat_3": myBiddingSeat_3,"seat_4": myBiddingSeat_4,"seat_5": myBiddingSeat_5,"seat_6": myBiddingSeat_6,"seat_7": myBiddingSeat_7,"seat_8": myBiddingSeat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
        }
//        if (oldOwnStatus != Ownstatus && Ownstatus == 2 && notBet) {
        if (Ownstatus == 1 && count > 15 && notBet) {
            notBet = false;
            console.log('status change', 'oldStatus', oldOwnStatus,'newStatus',Ownstatus);
            const totalBids = myBiddingSeat_1+myBiddingSeat_2+myBiddingSeat_3+myBiddingSeat_4+myBiddingSeat_5+myBiddingSeat_6+myBiddingSeat_7+myBiddingSeat_8;
            console.log('totalBids',totalBids);
            if (totalBids > 0) {
                console.log(totalBids);
                const user = await User.findOne({uid: userUid});
                if (user) {
                    if (user.balance >= totalBids) {
                        await User.updateOne({uid: userUid},{ $inc: { balance: -totalBids } });
                        const paymentBidding = new Payment();
                        paymentBidding.userId = userUid;
                        paymentBidding.coin = totalBids;
                        paymentBidding.type = 88
                        paymentBidding.isIncome = false;
                        paymentBidding.date = new Date().toLocaleString();
                        paymentBidding.save();

                        const gameTransaction = new GameTransaction();
                        gameTransaction.session = sessionId
                        gameTransaction.uid = userUid;
                        gameTransaction.name = userName;
                        gameTransaction.gameId = 3;
                        gameTransaction.coins = -totalBids;
                        gameTransaction.type = 0;
                        gameTransaction.save();
                        
                        const companyShare = (totalBids)*0.2;
                        const rotationShare = (totalBids)*0.8;
                        const companyBalance = await AppSetting.findOne({ name: 'greedy_company'});
                        companyBalance.valueInt = companyBalance.valueInt+companyShare;
                        await companyBalance.save();
                    }
                    if (myBiddingSeat_1 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_1;
                        greedyBid.seat = 1;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_2 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_2;
                        greedyBid.seat = 2;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_3 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_3;
                        greedyBid.seat = 3;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_4 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_4;
                        greedyBid.seat = 4;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_5 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_5;
                        greedyBid.seat = 5;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_6 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_6;
                        greedyBid.seat = 6;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_7 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_7;
                        greedyBid.seat = 7;
                        greedyBid.save();
                    }
                    if (myBiddingSeat_8 > 0) {
                        const greedyBid = new GreedyBid();
                        greedyBid.uid = userUid;
                        greedyBid.name = userName;
                        greedyBid.image = userImage;
                        greedyBid.session = sessionId
                        greedyBid.amount = myBiddingSeat_8;
                        greedyBid.seat = 8;
                        greedyBid.save();
                    }
        
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_1: myBiddingSeat_1 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_2: myBiddingSeat_2 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_3: myBiddingSeat_3 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_4: myBiddingSeat_4 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_5: myBiddingSeat_5 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_6: myBiddingSeat_6 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_7: myBiddingSeat_7 } });
                    await GreedyTable.updateOne({session: sessionId},{ $inc: { seat_8: myBiddingSeat_8 } });
                }
            }
        }
        oldOwnStatus = Ownstatus;
    },1000);
    socket.on("disconnect", async () => {
        myBiddingSeat_1 = 0;
        myBiddingSeat_2 = 0;
        myBiddingSeat_3 = 0;
        myBiddingSeat_4 = 0;
        myBiddingSeat_5 = 0;
        myBiddingSeat_6 = 0;
        myBiddingSeat_7 = 0;
        myBiddingSeat_8 = 0;
    });
    socket.on('bid', async (data) => {
        if (status == 1) {
            const response = JSON.parse(data);
            const bidder = response.uid;
            const bidderId = response.id;
            const amount = response.selectedBidding;
            const seat = response.seat;
            const user = await User.findOne({uid: bidder});
            if (user) {
                if (user.balance >= amount) {
                    userUid = user.uid
                    userName = user.fullname
                    userImage = user.image
                    if (seat == 1) {
                        seat_1 = seat_1+amount
                        actual_seat_1 = actual_seat_1+amount
                        myBiddingSeat_1 = myBiddingSeat_1+amount
                    }
                    else if (seat == 2) {
                        seat_2 = seat_2+amount
                        actual_seat_2 = actual_seat_2+amount
                        myBiddingSeat_2 = myBiddingSeat_2+amount
                    }
                    else if (seat == 3) {
                        seat_3 = seat_3+amount
                        actual_seat_3 = actual_seat_3+amount
                        myBiddingSeat_3 = myBiddingSeat_3+amount
                    }
                    else if (seat == 4) {
                        seat_4 = seat_4+amount
                        actual_seat_4 = actual_seat_4+amount
                        myBiddingSeat_4 = myBiddingSeat_4+amount
                    }
                    else if (seat == 5) {
                        seat_5 = seat_5+amount
                        actual_seat_5 = actual_seat_5+amount
                        myBiddingSeat_5 = myBiddingSeat_5+amount
                    }
                    else if (seat == 6) {
                        seat_6 = seat_6+amount
                        actual_seat_6 = actual_seat_6+amount
                        myBiddingSeat_6 = myBiddingSeat_6+amount
                    }
                    else if (seat == 7) {
                        seat_7 = seat_7+amount
                        actual_seat_7 = actual_seat_7+amount
                        myBiddingSeat_7 = myBiddingSeat_7+amount
                    }
                    else if (seat == 8) {
                        seat_8 = seat_8+amount
                        actual_seat_8 = actual_seat_8+amount
                        myBiddingSeat_8 = myBiddingSeat_8+amount
                    }
                    io.emit('sinbid', {"bidder": userUid,"seat": seat,"amount": amount});
                    io.emit('bidding', {"bidder": bidderId,"seat_1": myBiddingSeat_1,"seat_2": myBiddingSeat_2,"seat_3": myBiddingSeat_3,"seat_4": myBiddingSeat_4,"seat_5": myBiddingSeat_5,"seat_6": myBiddingSeat_6,"seat_7": myBiddingSeat_7,"seat_8": myBiddingSeat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
                    io.emit('bidding', {"bidder": 0,"seat_1": seat_1,"seat_2": seat_2,"seat_3": seat_3,"seat_4": seat_4,"seat_5": seat_5,"seat_6": seat_6,"seat_7": seat_7,"seat_8": seat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
                };
            };
        }
    })
})

var t=setInterval(async function () {
    const oldStatus = status;
    sessionId = (Math.floor(Math.floor(Date.now()/1000)/30));
    count = Math.floor(Date.now()/1000)-((Math.floor(Math.floor(Date.now()/1000)/30))*30);
    status = count < 20 ? 1 : (count < 25 ? 2 : 3);
    counter = count < 20 ? 20-count : (count < 25 ?  5-(count-20) : 5-(count-25));
    if (status == 1) {
        seat = Math.floor(1 + Math.random()*(3 - 1 + 1));
        amount = Math.floor(1 + Math.random()*(10 - 1 + 1))*10;
        if (seat == 1) {
            seat_1 = seat_1+amount
        }
        else if (seat == 2) {
            seat_2 = seat_2+amount
        }
        else if (seat == 3) {
            seat_3 = seat_3+amount
        }
        else if (seat == 4) {
            seat_4 = seat_4+amount
        }
        else if (seat == 5) {
            seat_5 = seat_5+amount
        }
        else if (seat == 6) {
            seat_6 = seat_6+amount
        }
        else if (seat == 7) {
            seat_7 = seat_7+amount
        }
        else if (seat == 8) {
            seat_8 = seat_8+amount
        }
        
        io.emit('bidding', {"bidder": 1,"seat_1": seat_1,"seat_2": seat_2,"seat_3": seat_3,"seat_4": seat_4,"seat_5": seat_5,"seat_6": seat_6,"seat_7": seat_7,"seat_8": seat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
    }
    if (oldStatus == 3 && status == 1) {
        customRes = false
        result = 0;
        seat_1 = 0;
        seat_2 = 0;
        seat_3 = 0;
        seat_4 = 0;
        seat_5 = 0;
        seat_6 = 0;
        seat_7 = 0;
        seat_8 = 0;
        actual_seat_1 = 0;
        actual_seat_2 = 0;
        actual_seat_3 = 0;
        actual_seat_4 = 0;
        actual_seat_5 = 0;
        actual_seat_6 = 0;
        actual_seat_7 = 0;
        actual_seat_8 = 0;
        io.emit('bidding', {"bidder": 0,"seat_1": seat_1,"seat_2": seat_2,"seat_3": seat_3,"seat_4": seat_4,"seat_5": seat_5,"seat_6": seat_6,"seat_7": seat_7,"seat_8": seat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
        io.emit('bidding', {"bidder": 1,"seat_1": seat_1,"seat_2": seat_2,"seat_3": seat_3,"seat_4": seat_4,"seat_5": seat_5,"seat_6": seat_6,"seat_7": seat_7,"seat_8": seat_8,"actual_seat_1": actual_seat_1,"actual_seat_2": actual_seat_2,"actual_seat_3": actual_seat_3,"actual_seat_4": actual_seat_4,"actual_seat_5": actual_seat_5,"actual_seat_6": actual_seat_6,"actual_seat_7": actual_seat_7,"actual_seat_8": actual_seat_8});
        const newGreedyTable = new GreedyTable();
        newGreedyTable.session = sessionId;
        newGreedyTable.result = 1;
        newGreedyTable.seat_1 = 0;
        newGreedyTable.seat_2 = 0;
        newGreedyTable.seat_3 = 0;
        await newGreedyTable.save();

        let history = [];
        const greedyHistory = await GreedyTable.aggregate([
            {
                $match: {
                    session: { $lt: sessionId } // Replace with actual sessionId ObjectId
                }
            },
            {
                $sort: { session: -1 } // Sort by session in descending order
            },
            {
                $limit: 15 // Limit results to 15 documents
            },
            {
                $project: {
                    result: 1, // Include only the "result" field
                    session: 1 // Convert session ObjectId to string
                }
            }
        ]);

        for (const value of greedyHistory) {
            const index = greedyHistory.indexOf(value);
            history.push(value.result);
        }
        io.emit('history', {"history": history});
        if (result == 0) {
            result = Math.floor(1 + Math.random()*(8 - 1 + 1));
            io.emit("setResultRes", result);
        }
    }
    if (oldStatus == 1 && status == 2) {
        let top3 = [];
        const greedyTopBidding = await GreedyBid.aggregate([
            {
                $match: {
                    session: sessionId,
                    seat: result
                }
            },
            {
                $group: {
                    _id: "$uid",
                    uid: { $first:"$uid" },
                    name: { $first:"$name" },
                    image: { $first:"$image" },
                    bidAmt: { $sum: "$amount" },
                    winBidAmt: {
                        $sum: {
                            $cond: {
                                if: { $and: [ { $eq: [ "$seat", result ] } ] },
                                then: "$amount",
                                else: 0
                            }
                        }
                    }
                }
            },
            {
                $sort: { winBidAmt: -1 }
            },
            {
                $limit: 3
            }
        ]);
        console.log('greedyTopBidding');
        console.log(JSON.stringify([
            {
                $match: {
                    session: sessionId,
                    seat: result
                }
            },
            {
                $group: {
                    _id: "$uid",
                    uid: { $first:"$uid" },
                    name: { $first:"$name" },
                    bidAmt: { $sum: "$amount" },
                    winBidAmt: {
                        $sum: {
                            $cond: {
                                if: { $and: [ { $eq: [ "$seat", result ] } ] },
                                then: "$amount",
                                else: 0
                            }
                        }
                    }
                }
            },
            {
                $sort: { winBidAmt: -1 }
            },
            {
                $limit: 3
            }
        ]));
        console.log(greedyTopBidding)
        for (const value of greedyTopBidding) {
            const index = greedyTopBidding.indexOf(value);
            const factors = [5, 10, 5, 15, 5, 25, 5, 45];
            top3.push({uid: value.uid, image: value.image, name: value.name, bid: value.bidAmt, win: value.winBidAmt*factors[result-1]});
        }
        if (top3.length === 0) {
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
        }
        else if (top3.length === 1) {
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
        }
        else if (top3.length === 2) {
            top3.push({uid: 0, name: '', image: '', bid: 0, win: 0});
        }
        console.log('result', {result: result, highscores: top3});
        io.emit('result', {result: result, highscores: top3});
    }
    if (oldStatus == 2 && status == 3) {
        console.log(Date.now(),"state result");

        await GreedyTable.updateOne({session: sessionId},{ $set: { result: result } });

        const greedyBidding = await GreedyBid.aggregate([
            {
                $match: {
                    session: sessionId
                }
            },
            {
                $group: {
                    _id: "$uid",
                    uid: { $first:"$uid" },
                    name: { $first:"$name" },
                    bidAmt: { $sum: "$amount" },
                    winBidAmt: {
                        $sum: {
                            $cond: {
                                if: { $and: [ { $eq: [ "$seat", result ] } ] },
                                then: "$amount",
                                else: 0
                            }
                        }
                    }
                }
            }
        ]);

        for (const value of greedyBidding) {
            console.log('biddings result',value)
            const index = greedyBidding.indexOf(value);
            const factors = [5, 10, 5, 15, 5, 25, 5, 45];
            const winning = value.winBidAmt*factors[result-1];
            io.emit('myresult', {uid: value.uid, bid: value.bidAmt, win: winning});
            if (winning > 0) {
                await User.updateOne({uid: value.uid},{ $inc: { balance: winning } });
                const paymentWinning = new Payment();
                paymentWinning.userId = value.uid;
                paymentWinning.coin = winning;
                paymentWinning.type = 88
                paymentWinning.isIncome = true;
                paymentWinning.date = new Date().toLocaleString();
                paymentWinning.save();
                const gameTransaction = new GameTransaction();
                gameTransaction.session = sessionId
                gameTransaction.uid = value.uid;
                gameTransaction.name = value.name;
                gameTransaction.gameId = 3;
                gameTransaction.coins = winning;
                gameTransaction.type = 1;
                gameTransaction.save();
                if (winning > 5000) {
                    const premiumMessage = value.name+" won "+winning+" Coins!";
                    notificationSocket.emit('game_notification', {gameType: 2,message: premiumMessage});
                }
            }
        }
    }
    io.emit('counter', counter);
    if (counter <= 5 && status != 3) {
        if (status == 1 && !customRes) {
            customRes = true;
            console.log(" round Roll: "+sessionId % 3800);
            //result = resultarrs[sessionId % 3800];
            //io.emit("setResultRes", result);
            const rotationBalance = await AppSetting.findOne({ name: 'greedy_rotation'});
            const totalBids = actual_seat_1+actual_seat_2+actual_seat_3+actual_seat_4+actual_seat_5+actual_seat_6+actual_seat_7+actual_seat_8;
            let rotationShare = Math.floor(totalBids*0.8);
            console.log('rotationShare',rotationShare);
            let maxReward = Math.floor(rotationShare * 8);
            rotationBalance.valueInt = rotationBalance.valueInt+rotationShare;
            if (maxReward > rotationBalance.valueInt) {
                maxReward = rotationBalance.valueInt;
            }
            console.log('rotationBalance',rotationBalance.valueInt);
            console.log('maxReward',maxReward);
            const array = [actual_seat_1*5,actual_seat_2*10,actual_seat_3*5,actual_seat_4*15,actual_seat_5*5,actual_seat_6*25,actual_seat_7*5,actual_seat_8*45];
            let suitvals = [];
            array.forEach((item, index) => {
                if (item < maxReward) {
                    suitvals.push(index+1);
                }
            });
            console.log('suitvals',suitvals);
            if (suitvals.length > 0) {
                result = suitvals[Math.floor(Math.random()*(suitvals.length))];
                console.log('final result suit', result);
                io.emit("setResultRes", result);
            }
            else {
                let largest = array[0];
                let largestIndex = 1;
                array.forEach((item, index, arr) => {
                    console.log(item,index,arr)
                    if (item < largest) {
                        console.log(item," < ",largest);
                        largest = item;
                        largestIndex = index+1;
                        result = largestIndex;;
                    }
                });
                if (array[0] == 0 && array[1] == 0 && array[2] == 0 && array[3] == 0 && array[4] == 0 && array[5] == 0 && array[6] == 0 && array[7] == 0) {
                    result = Math.floor(1 + Math.random()*(8 - 1 + 1));
                }
                console.log('final result random', result);
                io.emit("setResultRes", result)
            }
            rotationBalance.valueInt = rotationBalance.valueInt-array[result-1];
            console.log('add reward',array[result-1])
            console.log('add reward',rotationBalance.valueInt)
            await rotationBalance.save();
        }
        io.emit('status', 2);
    }
    else {
        io.emit('status', status);
    }
},1000);